 ; Ŀ
 ;   Ff - draw cables with fillets and an end break.                       
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 
 
 ; Ŀ
 ;   Fhook - fillet two lines.                                             
 ;   Arguments: two line enames.                                           
 ;   Returns the ename of the fillet, if one was created.                  
 ; 
 (DEFUN FHOOK (enta entb / plast dimsc lina linb tena elvna tenb elvnb lenga
                                              lengb pa ang1 ang2 p1 p2 disst)
  (setq plast (entlast))
  (setq dimsc (misps))
  (setq lina (entget enta))
  (setq linb (entget entb))
  (setq tena  (cdr (assoc 10 lina)))
  (setq elvna (cdr (assoc 11 lina)))
  (setq tenb  (cdr (assoc 10 linb)))
  (setq elvnb (cdr (assoc 11 linb)))
  (setq lenga (distance tena elvna))
  (setq lengb (distance tenb elvnb))
  (if (setq pa (inters tena elvna tenb elvnb nil))
      (progn
           (if (< (distance pa tena) (distance pa elvna))
               (setq ang1 (angle tena elvna))
               (setq ang1 (angle elvna tena)))
           (if (< (distance pa tenb) (distance pa elvnb))
               (setq ang2 (angle tenb elvnb))
               (setq ang2 (angle elvnb tenb)))
           (setq p1 (polar pa ang1 (* dimsc 5)))
           (setq p2 (polar pa ang2 (* dimsc 5)))
 ; Ŀ
 ;   Set Filletrad.                                                        
 ; 
           (setvar "filletrad" (* dimsc 3))
 ; Ŀ
 ;   See if the lines are long enough to fillet at the current radius and  
 ;   angle. If fil = 5 then the angle was 120 and lines at least 2.89     
 ;   units long are required.  If fil = 2 then the angle was 60 and 3.46  
 ;   will be removed from the end of each line by the fillet command.      
 ; 
           (if (and (> lenga (* 3 dimsc)) (> lengb (* 3 dimsc)))
               (progn
                    (setq disst (* dimsc 2))
                    (command "fillet" (list enta p1) (list entb p2))))))
 ; Ŀ
 ;   If a new entity was created, return its entity name.                  
 ; 
 (if (not (equal plast (setq elast (entlast))))
     elast))
 ; Ŀ
 ;   Fhook end.                                                            
 ; 

 ; Ŀ
 ;   Ff - the steam turbine.                                               
 ; 
 (DEFUN C:FF (/ *error* pa aa prelast llast ss nunam)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Do it.                                                                
 ; 
  (setq pa (getpoint "Start: "))
  (while (setq aa (getpoint pa))
         (command "line" pa aa "")
         (if ss
            (ssadd (entlast) ss)
            (setq ss (ssadd (entlast))))
         (if llast (setq prelast llast))
         (setq llast (entlast))
         (if (and prelast llast)
             (setq nunam (fhook prelast llast)))
         (if nunam (ssadd nunam ss))
         (setq pa aa))
 ; Ŀ
 ;   Make all the lines and arcs into a polyline.                          
 ; 
  (if (and ss (> (sslength ss) 1))
      (command ".pedit" (ssname ss 0) "y" "j" ss "" ""))
 ; Ŀ
 ;   Load Incend.                                                          
 ; 
  (if (not incend) (load "incend" ()))
 ; Ŀ
 ;   Call Incend to place the block.                                       
 ; 
  (if pa (setq enam (incend "linebrk" pa (misps))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))